//COMPARISON OF DIFFERENT POWER SPECTRUM ESTIMATES
//OS:Windows 10
//Scilab 5.5.2

clear all;
clc;
close;

Q = 10;  //Quality factor
N = 1000; //Length of the sample sequence
//Bartlett Method
F_Bartlett = Q/(1.11*N);
disp(F_Bartlett,'Frequency Resolution of Bartlett Power Spectrum Estimation')
//Welch Method
F_Welch = Q/(1.39*N);
disp(F_Welch,'Frequency Resolution of Welch Power Spectrum Estimation')
//Blackmann-Tukey Method
F_Blackmann_Tukey  = Q/(2.34*N);
disp(F_Blackmann_Tukey,'Frequency Resolution of Blackmann Tukey Power Spectrum Estimation')


//Output
// Frequency Resolution of Bartlett Power Spectrum Estimation
//
//   0.009009
//
// Frequency Resolution of Welch Power Spectrum Estimation
//
//   0.0071942
//
// Frequency Resolution of Blackmann Tukey Power Spectrum Esti 
// mation                                                     
//   0.0042735
